library("rgdal")
# library("rgeos")

file_data = read.csv("downloads/bikes.chicago.csv", fill=T, check.names=F)
file_data$City = "Chicago"
file_data = file_data[,c("stationName", "stAddress1", "totalDocks", "latitude", "longitude")]
colnames(file_data) = c("Name", "Address", "Docks", "Latitude", "Longitude")
csv = file_data

file_data = read.csv("downloads/bikes.nyc.csv", fill=T, check.names=F)
file_data$City = "New York"
file_data = file_data[,c("stationName", "stAddress1", "totalDocks", "latitude", "longitude")]
colnames(file_data) = colnames(csv)
csv = rbind(csv, file_data)

file_data = read.csv("downloads/bikes.san-antonio.csv", fill=T, check.names=F)
file_data$City = "San Antonio"
file_data = file_data[,c("site", "address", "docks_available", "latitude", "longitude")]
colnames(file_data) = colnames(csv)
csv = rbind(csv, file_data)

file_data = read.csv("downloads/bikes.houston.csv", fill=T, check.names=F)
file_data$City = "Houston"
file_data = file_data[,c("site", "address", "docks", "latitude", "longitude")]
colnames(file_data) = colnames(csv)
csv = rbind(csv, file_data)

# Convert to SpatialPoints and SpatialDataFrame

csv_points = SpatialPoints(coords = csv[, c("Longitude","Latitude")], 
	proj4string=CRS("+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs"))
geospatial = SpatialPointsDataFrame(coords = csv_points, data = csv)


# Save as shapefile

writeOGR(geospatial, dsn="/home/michael/mapping-sustainability/bike-sharing",
	layer="bike-sharing", driver="ESRI Shapefile", overwrite_layer=T)

