<?php

$files = array("1907-stables.txt", "1926-autos.txt");
echo "Year,Category,Business,Number,Street,Phone\n";

$category = "";
foreach ($files as $filename)
{
	$year = substr($filename, 0, 4);
	$file = fopen($filename, "r");
	while ($line = fgets($file))
	{
		$line = trim($line);
		if (strlen($line) && ($line[0] == '*'))
		{
			$category = trim(substr($line, 1));
			if ($seealso = strpos($category, '('))
				$category = trim(substr($category, 0, $seealso));
			$category = ucwords(strtolower($category));
		}

		else if (substr($line, 0, 2) == 'x ')
			; // skip line

		else if (strlen($line))
		{
			$phone = NULL;
			if ($phonestart = strpos($line, "Tel."))
			{
				$phone = trim(substr($line, $phonestart + 4));
				$line = trim(substr($line, 0, $phonestart));
			}

			if ($roomstart = strpos($line, "Room"))
				$line = trim(substr($line, 0, $roomstart));

			if ($line[strlen($line) - 1] == '.')
				$line = substr($line, 0, strlen($line) - 1);

			$numberstart = 0;
			while (($numberstart < strlen($line)) && !ctype_digit($line[$numberstart]))
				++$numberstart;

			if ($numberstart >= strlen($line))
			{
				$numberstart = strpos($line, ",");
				if ($numberstart)
					++$numberstart;
			}

			if ($atstart = strpos($line, " at "))
			{
				$numberstart = $atstart;
				while (($numberstart > 0) && ($line[$numberstart] != ','))
					--$numberstart;
				if ($numberstart > 0)
					++$numberstart;
				//echo "-- $numberstart: $line\n";
			}

			if ($numberstart && ($numberstart < strlen($line)))
			{
				$company = trim(substr($line, 0, $numberstart));
				if ($company[strlen($company) - 1] == ',')
					$company = substr($company, 0, strlen($company) - 1);

				$numberend = $numberstart;
				while (($numberend < strlen($line)) && 
					(ctype_digit($line[$numberend]) || ($line[$numberend] == '-')))
					++$numberend;

				$number = substr($line, $numberstart, $numberend - $numberstart);
				$street = trim(substr($line, $numberend));
			}

			elseif ($intersect = strrchr($line, ","))
			{
				$company = trim(substr($line, 0, $intersect));
				$street = trim(substr($line, $intersect + 1));
				$number = "";
			}
			else
			{
				$company = $line;
				$number = "";
				$street = "";
			}

			$company = ucwords(strtolower($company));

			if (!strncmp($street, "E ", 2))
				$street = "East " . substr($street, 2);
			if (!strncmp($street, "W ", 2))
				$street = "West " . substr($street, 2);
			if (!strncmp($street, "St.", 3))
				$street = "Saint " . substr($street, 3);

			if ((strlen($street) > 3) && !strcasecmp(substr($street, strlen($street) - 2), " W"))
				$street = substr($street, 0, strlen($street) - 2) . " West";
			if ((strlen($street) > 3) && !strcasecmp(substr($street, strlen($street) - 3), " av"))
				$street = substr($street, 0, strlen($street) - 3) . " Avenue";
			if ((strlen($street) > 3) && !strcasecmp(substr($street, strlen($street) - 3), " rd"))
				$street = substr($street, 0, strlen($street) - 3) . " Road";
			if ((strlen($street) > 3) && !strcasecmp(substr($street, strlen($street) - 3), " pl"))
				$street = substr($street, 0, strlen($street) - 3) . " Place";
			if ((strlen($street) > 3) && !strcasecmp(substr($street, strlen($street) - 3), " pt"))
				$street = substr($street, 0, strlen($street) - 3) . " Point";
			if ((strlen($street) > 2) && (substr($street, strlen($street) - 2) == '2d'))
				$street = substr($street, 0, strlen($street) - 1) . "nd Street";
			if ((strlen($street) > 2) && (substr($street, strlen($street) - 2) == '3d'))
				$street = substr($street, 0, strlen($street) - 1) . "rd Street";

			$streetsuffix = "xx";
			if ((strlen($street) > 3) && ctype_digit($street[strlen($street) - 3]))
				$streetsuffix = substr($street, strlen($street) - 2);

			if (($streetsuffix == 'th') || ($streetsuffix == 'st') || 
			    ($streetsuffix == 'nd') || ($streetsuffix == 'rd'))
				$street .= " Street";

			/**
			if ((strlen($street) > 3) && (substr($street, strlen($street) - 3) == ' rd'))
				$street = substr($street, 0, strlen($street) - 3) . " Road";
			else if ((strlen($street) > 3) && (substr($street, strlen($street) - 3) == ' av'))
				$street = substr($street, 0, strlen($street) - 3) . " Avenue";
			else
				$street .= " Street";
			**/

			$street = str_replace(" W.", " West", $street);
			$street = str_replace(" W ", " West ", $street);
			$street = str_replace(" E.", " East", $street);
			$street = str_replace(" E ", " East ", $street);
			$street = str_replace(" Av.", " Avenue", $street);
			$street = str_replace(" Av ", " Avenue ", $street);
			$street = str_replace(" av ", " Avenue ", $street);
			$street = str_replace(" pk ", " Park ", $street);
			$street = str_replace("Bway.", "Broadway", $street);
			$street = str_replace("Bway", "Broadway", $street);
			$street = str_replace("Lex ", "Lexington ", $street);
			$street = str_replace("Ams ", "Amsterdam ", $street);
			$street = str_replace("Ams. ", "Amsterdam ", $street);
			$street = str_replace("Washn", "Washington", $street);
			$street = str_replace("Gwich", "Greenwich", $street);
			$street = str_replace("Mhtn", "Manhattan", $street);

			echo "$year,\"$category\",\"$company\",$number,\"$street\",$phone\n";
		}
	}
}
?>
