<?php

// http://www.health.state.ny.us/statistics/cancer/registry/appendix/neighborhoods.htm
// http://www.visitingdc.com/zip-code-new-york/new-york-city-zip-code.asp
// http://maps.google.com/maps?f=q&source=s_q&hl=en&geocode=&q=parking+garages+near+10001&vps=1&jsv=172d&sll=40.872984,-73.927164&sspn=0.031867,0.050468&ie=UTF8&sa=N&start=10

$manhattan = array(10001,10002,10003,10004,10005,10006,10007,10009,10010,10011,10012,10013,
		10014,10015,10016,10017,10018,10019,10020,10021,10022,10023,10024,10025,10026,10027,10028,
		10029,10030,10031,10032,10033,10034,10035,10036,10037,10038,10039,10040,10041,10044,10045,
		10048,10055,10060,10069,10090,10095,10098,10099,10103,10104,10105,10106,10107,10110,10111,
		10112,10115,10118,10119,10120,10121,10122,10123,10128,10151,10152,10153,10154,10155,10158,
		10161,10162,10165,10166,10167,10168,10169,10170,10171,10172,10173,10174,10175,10176,10177,
		10178,10199,10270,10271,10278,10279,10280,10281,10282);

# Automation detection began after 4140 downloads (zip=10045 start=40)

$maxresults = 100;

echo "Name,Street,Phone,Google\n";

foreach ($manhattan as $zip)
	for ($startnum = 0; $startnum < $maxresults; $startnum += 10)
	{
		$url = "http://maps.google.com/maps?source=s_q&hl=en&geocode=&q=category:%22Parking+Garage%22" .
		"&vps=1&jsv=172d&sll=40.872984,-73.927164&sspn=0.031867,0.050468&ie=UTF8&near=" . 
		$zip . "&oi=ls_category&sa=X&ct=result&cd=1&start=" . $startnum;

		$html = file_get_contents($url);
		if (strlen($html) <= 0)
			$startnum = $maxresults;

		$x = strpos($html, "<div class=\"name", $x);
		while ($x > 0)
		{
			$end = strpos($html, "<div class=\"name", $x + 1);
			if ($end <= 0)
				$end = strlen($html);
			$garage = substr($html, $x, $end - $x);

			$link = "";
			if ($y = strpos($garage, "<a href="))
			{
				$end = strpos($garage, " ", $y + 8);
				$link = substr($garage, $y + 8, $end - $y - 8);
			}

			$name = "";
			if ($y = strpos($garage, "<span id=title"))
			{
				$start = strpos($garage, ">", $y) + 1;
				$end = strpos($garage, "</span>", $start);
				$name = substr($garage, $start, $end - $start);
			}
	
			$street = "";
			if ($y = strpos($garage, "<span class=street-address>"))
			{
				$end = strpos($garage, "</span>", $y);
				$street = substr($garage, $y + 27, $end - $y - 27);
			}

			$phone = "";
			if ($y = strpos($garage, "<span class=tel>"))
			{
				$end = strpos($garage, "</span>", $y);
				$phone = substr($garage, $y + 16, $end - $y - 16);
			}

			if (strlen($name))
				echo "\"$name\",\"$street\",\"$phone\",\"http://maps.google.com$link\"\n";

			$x = strpos($html, "<div class=\"name", $x + 1);
		}
	}
?>
