<?php

if ($argc < 2)
	die("Syntax: php remove-duplicates.php infile.csv column > outfile.csv\n");

$infile = fopen($argv[1], "r");
$column = intval($argv[2]);
$previous = array();

$incount = 0;
$dupcount = 0;

while (($data = fgetcsv($infile)) != FALSE)
{
	++$incount;
	if ((count($previous) <= $column) || (count($data) <= $column) || ($previous[$column] != $data[$column]))
		fputcsv(STDOUT, $data);
	else
		++$dupcount;

	$previous = $data;
}

fclose($infile);

echo "$dupcount of $incount duplicated\n";

?>
